import copy
import json
from typing import Any

from fastapi import FastAPI, UploadFile, HTTPException
import chardet

from logics import Logics

app = FastAPI()


def add_logic_json(data: Any) -> Any:
    main_component = data.get("components", "")
    if not main_component:
        return "invalid file format"
    new_section = []
    for section in main_component:
        if section.get("type", "") == "table":
            section_rows = section.get("rows", "")
            if section_rows:
                new_rows = []
                for rows in section_rows:
                    new_column = []
                    for columns in rows:
                        """new changes"""
                        """FYI"""
                        new_column_component = []
                        for column_components in columns["components"]:
                            if column_components.get("type", "") in ["select", "textfield", "textarea",
                                                                     "button-group", "number"]:
                                if column_components.get("logic", "") or column_components["validate"].get(
                                        "required", ""):
                                    current_key = column_components.get("key")
                                    logic_to_add = copy.deepcopy(Logics.not_required)
                                    logic_to_add["trigger"]["javascript"] = f'result = data.{current_key}'
                                    if column_components.get("logic", ""):
                                        column_components["logic"].append(logic_to_add)
                                    else:
                                        column_components["logic"] = [logic_to_add]
                            new_column_component.append(column_components)
                        new_column.append({"components": new_column_component})
                    new_rows.append(new_column)
                section["rows"] = new_rows
        new_section.append(section)
    data["components"] = new_section
    return data


@app.post("/add_logic")
async def add_logic(file: UploadFile = UploadFile(...)):
    try:
        content = await file.read()
        encoding_result = chardet.detect(content)
        file_encoding = encoding_result['encoding']
        json_data = json.loads(content.decode(file_encoding))
        updated_json = add_logic_json(json_data)
        return updated_json
    except json.JSONDecodeError:
        raise HTTPException(status_code=400, detail="Invalid JSON format in the uploaded file.")
